#!/usr/bin/env python3
# run_f17_v6.py — convenience runner for F17_v6
import os, sys
from datetime import datetime, timezone
from subprocess import run

here = os.path.dirname(os.path.abspath(__file__))
engine = os.path.join(here, "engine_f17_two_source_v6.py")
manifest = os.path.join(here, "config", "manifest_f17_v6.json")

ts = datetime.now(timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")
outdir = os.path.join(here, "F17_two_source_v6", ts)
os.makedirs(outdir, exist_ok=True)
print("Running F17_v6 ->", outdir)
cmd = [sys.executable, engine, "--manifest", manifest, "--outdir", outdir]
res = run(cmd, check=False, capture_output=True, text=True)
print(res.stdout)
if res.stderr:
    print("STDERR:", res.stderr)
print("Artifacts in:", outdir)
